<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transaction extends Model 
{

    protected $table = 'transactions';
    public $timestamps = true;
    protected $fillable = array('user_id', 'client_id', 'amount', 'request_status');

    public function users()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function transactionType()
    {
        return $this->hasOne('App\Models\TransactionType', 'transaction_type_id');
    }

}